CREATE PROCEDURE [dbo].[CPU_CleverResto_Facturar]	@Id_Mesa_Mov	INT

AS
BEGIN

---------------------------------agrego los productos------------------------------------------
insert into Productos 
(Id_Producto, Descripcion_Detallada, Descripcion_Resumida,Cantidad,Costo,Precio_Final,Observaciones,Vendible
,Activo,Precio_Gravado,Id_Iva)

select 'CR' + CAST(P.Id_Producto as VARCHAR(10))
,LTRIM(RTRIM(Descripcion)) +' - '+ CAST(P.Id_Producto as VARCHAR(10)),Descripcion_Corta,Cantidad,Costo,Precio,Observaciones,Vendible
,Activo, Precio / 1.21,1  
from Pub_Resaltar.dbo.Productos P
where not exists (select 1 from Productos where Id_Producto = 'CR' + CAST(P.Id_Producto as VARCHAR(10)))


---------------------------------------------------------------------------------------------------------
DECLARE @Lote VARCHAR(20)
		,@Fecha DATETIME
		,@FechaVence DATETIME
		,@Id_Cliente INT
		,@Id_Tipo_Cbte CHAR(4)
		,@Id_Cond_Pago INT
		,@Id_Moneda CHAR(3)
		,@Cotizacion DECIMAL(12,4)
		,@Importe	DECIMAL(12,2)
		,@imp_gravado DECIMAL(12,2)
		,@imp_desc DECIMAL(12,2)
		,@porc_desc DECIMAL(7,2)
		,@Nombre	VARCHAR(100)

DECLARE	@Id_Trans		INT,
	@Item		INT,
	@Id_Producto CHAR(14),
	@Cantidad decimal(12,2),
	@Nota		VARCHAR(200),
	@Importe_Item	DECIMAL(12,2),
	@descripcion_producto VARCHAR(100),
	@Suc  INT,
	@Imp_iva DECIMAL(12,2)
	


DECLARE @Id_Iva	CHAR(3)
		,@Cuit		VARCHAR(13)
		,@Doc_Nro   BIGINT


---------------------------------------------------------------------------------------------------------


BEGIN TRY  
BEGIN TRAN


--------------------------- Seteos Generales -----------------------------------------------

SELECT	@Id_Cliente = Id_Cliente ,@Fecha = M.Cierre ,@FechaVence = M.Cierre	,@Importe	= M.Imp_Neto 
		,@porc_desc = porc_desc,@imp_desc = imp_desc
        FROM Pub_Resaltar.dbo.Mesas_Mov M WHERE M.Id_Mesa_Mov = @Id_Mesa_Mov

IF ISNULL(@imp_desc,0) <> 0 
	SET @imp_desc = @imp_desc / 1.21

IF ISNULL(@Id_Cliente,0) = 0     	
	SET @Id_Cliente = dbo.CF_xParam('Id_Cliente_CF')

SELECT	@Id_Iva = Id_Iva, @Cuit = Cuit ,@Doc_Nro = Doc_Nro, @Nombre = Razon_Social FROM Clientes WHERE Id_Cliente = @Id_Cliente
		

SET @Lote = ''
SET @Id_Cond_Pago = 1
SET @Id_Moneda = dbo.CF_xParam('Moneda_Nacional')
SET @Cotizacion = 1
		
IF @Id_Iva = dbo.CF_xParam('Iva_CF') OR @Id_Iva = dbo.CF_xParam('Iva_CF_DNI') OR @Id_Iva = dbo.CF_xParam('Iva_Exento')
	SET @Id_Tipo_Cbte = 'FBE'
ELSE
	SET @Id_Tipo_Cbte = 'FAE'

SET @Suc = (SELECT Id_Sucursal FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte)

-------------------------------------Agreggo Transacciones Y Cbtes-----------------------------------------------------

SET @Id_Trans = (SELECT max(id_trans) from transacciones ) + 1
SET @imp_gravado = @Importe / 1.21

INSERT INTO TRANSACCIONES (id_trans,descripcion,fecha_mov) values (@Id_Trans,'Clever_Resto ' + CAST(@Id_Mesa_Mov AS VARCHAR(10)),GETDATE())

SET @Fecha = CAST(@Fecha AS DATE)

INSERT INTO CBTES (	Id_Cond_Vta		,Id_trans			,Id_Sucursal		,Cbte_Grupo,			Fecha_Venc     
					,id_cliente		,id_estado_Cbte		,id_tipo_cbte,		comprobante_nro,		fecha
					,periodo_iva	,periodo			,imp_total			,saldo					,imp_gravado			
					,destinatario	,lote			    ,ID_MONEDA			,Id_Cond_Pago				,Cotizacion	
					,Cuit
					,Porc_Bonificacion ,Porc_DescEspecial ,Porc_DescFin, Porc_Iva ,Porc_Iva2 ,Porc_Iva3
					,Imp_Bonificacion,Imp_Neto ,Imp_DescEspecial, Imp_DescFin ,Imp_Gravado2 ,Imp_Gravado3 ,Imp_Exento , Imp_NoGravado
					,Imp_IVA ,Imp_IVA2 ,Imp_IVA3,Imp_Percep,Imp_Percepcion_IB,Imp_Percepcion_Iva
					,Id_Iva , NRO_DJAI
					)
		   values (	''				,@Id_Trans			,@Suc				,0						,@FECHA    
					,@id_cliente	,0					,@Id_Tipo_cbte		,0						,@FECHA
					,@FECHA			,@FECHA				,@Importe			,@Importe				,@imp_gravado			
					,@NOMBRE		,@Lote			,@Id_Moneda			,@Id_Cond_Pago				,@Cotizacion
					,@cuit
					,@porc_desc ,0 ,0, 21 ,0 ,0
					,@imp_desc,@imp_gravado ,0, 0 ,0 ,0 ,0 ,0
					,@Importe - @imp_gravado ,0 ,0,0,0,0
					,@Id_Iva , @Id_Mesa_Mov
					)


-----------------------Agrego Items --------------------------------------------------------------------------------------

DECLARE CP_CleverResto_Facturar_Cur CURSOR FOR  
		SELECT Item,'CR' + CAST(I.Id_Producto as VARCHAR(10)),I.Cantidad,Imp_Neto ,P.Descripcion_Corta
		FROM Pub_Resaltar.dbo.Mesas_Mov_Items I , Pub_Resaltar.dbo.Productos P
		WHERE I.Id_Mesa_Mov = @Id_Mesa_Mov 
		AND P.Id_Producto = I.Id_Producto

OPEN CP_CleverResto_Facturar_Cur

FETCH NEXT FROM CP_CleverResto_Facturar_Cur INTO @Item , @Id_Producto , @Cantidad, @Importe_Item , @descripcion_producto

WHILE @@FETCH_STATUS = 0
BEGIN
		SET @Imp_iva = @Importe_Item - (@Importe_Item / 1.21)
		INSERT INTO Cbtes_Items		(id_cliente,		descripcion_producto,		Cantidad,
							id_estado_Cbte,		Cantidad_Saldo,				Id_Trans,
							item,				Precio_Grav,				Imp_Gravado,
							Imp_Final,			Precio,						Lote,
							Flag_QA,					Id_Producto
							,Precio_Exen ,Porc_Iva ,Bonif , Costo ,Imp_Iva
							)
				VALUES		(@id_cliente,		RTRIM(@descripcion_producto),1,
							0,					1,							@Id_Trans,
							@Item,				@Importe_Item / 1.21 / @Cantidad,					@Importe_Item / 1.21,
							@Importe_Item,		@Importe_Item / 1.21 / @Cantidad,					'',
							'A',				@Id_Producto
							,0 , 21 , 0 , 0 ,@Imp_iva
							)

		FETCH NEXT FROM CP_CleverResto_Facturar_Cur INTO @Item , @Id_Producto , @Cantidad, @Importe_Item , @descripcion_producto
								
END
CLOSE CP_CleverResto_Facturar_Cur
DEALLOCATE CP_CleverResto_Facturar_Cur

UPDATE Cbtes			SET Id_Estado_Cbte = 16,Saldo = 0	WHERE Id_Trans = @Id_Trans
UPDATE Cbtes_Items		SET Id_Estado_Cbte = 16				WHERE Id_Trans = @Id_Trans
UPDATE Clientes_CtaCte	SET Id_Estado_Cbte = 16, Saldo = 0  wHERE Id_Trans = @Id_Trans
UPDATE Cajas_Mov		SET Id_Estado_Mov_Caja = 2			WHERE Id_Trans = @Id_Trans  

COMMIT
END TRY  

BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   



END
